/*REXX program to generate the HyperMake docu of your choice*/

"@..\HMAKE TEST_IF_HERE >NUL"
if \ (rc = 0) then DO
  say "To create the HyperMake docu, please make the directory ENGLISH"
  say "(located in the HyperMake directory) current, and then start"
  say "MakeDocu.cmd oncemore !"
  exit
END

"mode 80,99"
say "This HyperMake installation script generates"
say "the HyperMake docu of your choice."
say ""
say "HyperMake can generate both IPF files and HTML files."
say "You can omit the parts of the docu which aren't"
say "interested for you. Select Y for yes and N for no."
say "and press Return"
say ""
MakeIPF = "FALSE"
MakeHTML = "FALSE"
say "IPF files are needed to create IBM INF and HLP files."
say "To create INF and HLP files from an IPF file, you need the"
say "IBM IPFC Compiler."
say "Are you interested in generating IPF files ?"
pull YesNo
Condition = ""
if (YesNo = "Y") | (YesNo = "y") then DO
  Condition = Condition "#IPFDOC"
  "@IPFC >NUL"
  if \ (rc = 0) then DO
    say "To create the HyperMake docu in IBM INF format, IPFC has to be"
    say "installed. But IPFC.EXE could not be found. So it's only possible"
    say "to create the docu in HTML format."
    say "If you have got IPFC.EXE, it's necessary that IPFC.EXE is placed"
    say "in a directory placed in the PATH list or in this directory."
    say "Do you want to continue ?"
    pull YesNo
    if (YesNo = "N") | (YesNo = "n") then EXIT
  END
  ELSE DO
    MakeIPF = "TRUE"
    say "IBM INF files are a stand alone solution. HLP files are part of"
    say "a program, so if you aren't a programmer, you need not to create"
    say "HLP files."
    say "Are you also interested in generating HLP files ?"
    pull YesNo
    if (YesNo = "Y") | (YesNo = "y") then Condition = Condition "#HLPDOC"
  END
END
say "To view HTML files, you need a Browser like IBM WebExplorer"
say "or Netscape. (Netscape is better because it supports Frames"
say "and colors.)"
say "Are you interested in generating HTML files ?"
pull YesNo
if (YesNo = "Y") | (YesNo = "y") then DO
  Condition = Condition "#HTMLDOC"
  MakeHTML = "TRUE"
END
say "Are you perhaps interested in using an old DOS WordStar"
say "instead of an ASCII editor ?"
pull YesNo
if (YesNo = "Y") | (YesNo = "y") then Condition = Condition "#WORDSTARDOC"

say "The compiler conditions you have chosen are:" Condition
say ""
if (MakeIPF = "FALSE") & (MakeHTML = "FALSE") then DO
  say "Oops. You are neither interested in HTML files nor in IPF files."
  say "Restart the install program and read the questions!"
  say "press Return"
  pull WaitReturn
  EXIT
END

say "Now HyperMake (HMAKE.EXE) is executed to create the docu"
if MakeHTML = "TRUE" then DO
  say "in HTML format (see filename DOCU\INDEX.HTML for the content)"
END
if (MakeHTML = "TRUE") & (MakeIPF = "TRUE") then DO
  say "and"
END
if MakeIPF = "TRUE" then DO
  say "in IBM INF format (see filename DOCU.INF)"
END

say ""
say "Do you want to take a look at the ASCII sources from which"
say "HyperMake generates the docu?"
pull YesNo
if (YesNo = "Y") | (YesNo = "y") then DO
  "start /f e sample.txt"
  "start /f e docu.txt"
  say "press Return to continue"
  pull WaitReturn
END
if MakeHTML = "TRUE" then DO
  "..\hmake HTML sample.txt english.ini" 
  "..\hmake HTML docu.txt english.ini" Condition
  "copy ..\*.gif DOCU" 
  "copy ..\*.gif SAMPLE" 
  "copy buttons\*.gif DOCU" 
  "copy buttons\*.gif SAMPLE"

       Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
       Call SysLoadFuncs
       CurrentDir = directory()
       Call SysCreateObject "WPDataFile", "Index.html", CurrentDir"\Docu",,
	    "OBJECTID=<Hmake_Docu_Index>;","U"
       Call SysCreateObject "WPShadow", "Index.html", CurrentDir,,
	    "SHADOWID=<Hmake_Docu_Index>;"
       Call SysOpenObject CurrentDir"\Sample", ICON, TRUE
 
END
if MakeIPF = "TRUE" then DO
  "..\hmake IPF sample.txt english.ini" 
  "..\hmake IPF docu.txt english.ini" Condition
  "copy ..\*.bmp"
  "IPFC /inf sample.ipf"
  "IPFC /inf docu.ipf"
  "del *.bmp"
END
say ""
say "The docu and the sample text has been created."
say "press Return"
pull WaitReturn
